/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.BiomeDimensionAllowDisallow;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class BiomeSelection {
    private static Set<RegistryKey<Biome>> OVERWORLD_BIOMES = new HashSet<RegistryKey<Biome>>();

    public static void setupOverworldBiomesSet() {
        OVERWORLD_BIOMES.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.OVERWORLD));
        OVERWORLD_BIOMES.addAll(BiomeManager.getAdditionalOverworldBiomes());
    }

    public static boolean isOverworldBiome(BiomeLoadingEvent event) {
        RegistryKey biomeKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)event.getName());
        return OVERWORLD_BIOMES.contains(biomeKey);
    }

    public static boolean hasName(BiomeLoadingEvent context, String ... names) {
        return Arrays.stream(names).anyMatch(name -> context.getName().func_110623_a().contains((CharSequence)name));
    }

    public static boolean hasNamespace(BiomeLoadingEvent context, String ... namespace) {
        return Arrays.stream(namespace).anyMatch(name -> context.getName().func_110624_b().contains((CharSequence)name));
    }

    @SafeVarargs
    public static boolean isBiome(BiomeLoadingEvent context, RegistryKey<Biome> ... keys) {
        return Arrays.stream(keys).anyMatch(key -> context.getName().equals((Object)key.func_240901_a_()));
    }

    public static boolean haveCategories(BiomeLoadingEvent context, Biome.Category ... categories) {
        HashSet<Biome.Category> categorySet = new HashSet<Biome.Category>(Arrays.asList(categories));
        return categorySet.contains(context.getCategory());
    }

    public static boolean hasStructure(BiomeLoadingEvent context, Structure<?> structureFeature) {
        return context.getGeneration().getStructures().stream().anyMatch(structureFeatureSupplier -> ((StructureFeature)structureFeatureSupplier.get()).field_236268_b_.equals(structureFeature));
    }

    public static boolean hasStructureType(BiomeLoadingEvent context, RSStructureTagMap.STRUCTURE_TAGS tag) {
        return RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag).stream().anyMatch(structure -> context.getGeneration().getStructures().stream().anyMatch(structureFeatureSupplier -> ((StructureFeature)structureFeatureSupplier.get()).field_236268_b_.equals(structure)));
    }

    public static boolean doesNotHaveStructureType(BiomeLoadingEvent context, RSStructureTagMap.STRUCTURE_TAGS tag) {
        return RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag).stream().noneMatch(structure -> context.getGeneration().getStructures().stream().anyMatch(structureFeatureSupplier -> ((StructureFeature)structureFeatureSupplier.get()).field_236268_b_.equals(structure)));
    }

    public static boolean doesHaveStructureType(BiomeLoadingEvent context, RSStructureTagMap.STRUCTURE_TAGS tag) {
        return RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag).stream().anyMatch(structure -> context.getGeneration().getStructures().stream().anyMatch(structureFeatureSupplier -> ((StructureFeature)structureFeatureSupplier.get()).field_236268_b_.equals(structure)));
    }

    public static boolean isBiomeAllowed(BiomeLoadingEvent context, Structure<?> structureFeature, Supplier<Boolean> defaultCondition) {
        return BiomeSelection.isBiomeAllowed(context, structureFeature, Registry.field_218361_B) || !BiomeSelection.isBiomeDisallowed(context, structureFeature, Registry.field_218361_B) && defaultCondition.get() != false;
    }

    public static boolean isBiomeAllowed(BiomeLoadingEvent context, ConfiguredFeature<?, ?> configuredFeature, Supplier<Boolean> defaultCondition) {
        return BiomeSelection.isBiomeAllowed(context, configuredFeature, WorldGenRegistries.field_243653_e) || !BiomeSelection.isBiomeDisallowed(context, configuredFeature, WorldGenRegistries.field_243653_e) && defaultCondition.get() != false;
    }

    public static <T> boolean isBiomeAllowed(BiomeLoadingEvent context, T worldgenObject, Registry<T> registry) {
        ResourceLocation registryId = registry.func_177774_c(worldgenObject);
        String biomeID = context.getName().toString();
        return ((List)BiomeDimensionAllowDisallow.BIOME_ALLOW.getOrDefault(registryId, new ArrayList())).stream().anyMatch(pattern -> {
            if (pattern.pattern().startsWith("#")) {
                String cleanedUpCategoryString = pattern.pattern().trim().toLowerCase(Locale.ROOT).replace("#", "");
                Biome.Category category = Biome.Category.func_235103_a_((String)cleanedUpCategoryString);
                if (category == null) {
                    RepurposedStructures.LOGGER.warn("Unknown biome category detected in one of the biome allow configs: {}", (Object)cleanedUpCategoryString);
                } else {
                    return context.getCategory().equals((Object)category);
                }
            }
            return pattern.matcher(biomeID).matches();
        });
    }

    public static <T> boolean isBiomeDisallowed(BiomeLoadingEvent context, T worldgenObject, Registry<T> registry) {
        ResourceLocation registryId = registry.func_177774_c(worldgenObject);
        String biomeID = context.getName().toString();
        return ((List)BiomeDimensionAllowDisallow.BIOME_DISALLOW.getOrDefault(registryId, new ArrayList())).stream().anyMatch(pattern -> {
            if (pattern.pattern().startsWith("#")) {
                String cleanedUpCategoryString = pattern.pattern().trim().toLowerCase(Locale.ROOT).replace("#", "");
                Biome.Category category = Biome.Category.func_235103_a_((String)cleanedUpCategoryString);
                if (category == null) {
                    RepurposedStructures.LOGGER.warn("Unknown biome category detected in one of the biome disallow configs: {}", (Object)cleanedUpCategoryString);
                } else {
                    return context.getCategory().equals((Object)category);
                }
            }
            return pattern.matcher(biomeID).matches();
        });
    }

    public static boolean hasFeature(BiomeLoadingEvent context, ConfiguredFeature<?, ?> configuredFeature) {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            for (Supplier featureSuppliers : context.getGeneration().getFeatures(stage)) {
                if (featureSuppliers.get() != configuredFeature) continue;
                return true;
            }
        }
        return false;
    }
}

